/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design;

import filenet.vw.api.VWException;
import filenet.vw.api.VWUserInfo;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import java.awt.Color;

public class VWDesignerPreferences {
    private boolean m_bValidateBeforeTransfer = true;
    private boolean m_bAddCheckIn = true;
    private boolean m_bDisplayInheritedInformation = true;
    private boolean m_bUseSameStepTab = false;
    private boolean m_bUseSameRouteTab = true;
    private boolean m_bUseSameTextAnnotationTab = true;
    private boolean m_bUseSameAssociationTab = true;
    private VWDesignerCoreData m_designerCoreData = null;

    public VWDesignerPreferences(VWDesignerCoreData designerCoreData) {
        this.m_designerCoreData = designerCoreData;
    }

    public void initPreferenceSettings() {
        try {
            VWMapAttribs mapAttribs = this.m_designerCoreData.getMapAttributes();
            VWUserInfo userInfo = this.m_designerCoreData.getSessionInfo().getSession().fetchCurrentUserInfo();
            Object obj = userInfo.getFieldValue("designer_show_stepnames");
            if (obj != null) {
                mapAttribs.setStepNameVisible((Boolean)obj);
            }
            if ((obj = userInfo.getFieldValue("designer_show_routenames")) != null) {
                mapAttribs.setRouteNameVisible((Boolean)obj);
            }
            if ((obj = userInfo.getFieldValue("designer_show_milestoneicons")) != null) {
                mapAttribs.setMilestoneVisible((Boolean)obj);
            }
            if ((obj = userInfo.getFieldValue("designer_show_conditionalroutes")) != null) {
                mapAttribs.setConditionAttrsVisible((Boolean)obj);
            }
            if ((obj = userInfo.getFieldValue("designer_show_collectorstepicons")) != null) {
                mapAttribs.setCollectorAttrsVisible((Boolean)obj);
            }
            if ((obj = userInfo.getFieldValue("designer_show_textannotations")) != null) {
                mapAttribs.setTextAnnotationsVisible((Boolean)obj);
            }
            if ((obj = userInfo.getFieldValue("designer_show_pageboundaries")) != null) {
                mapAttribs.setPageBoundaryVisible((Boolean)obj);
            }
            if ((obj = userInfo.getFieldValue("designer_text_annotation_bgcolor")) != null) {
                mapAttribs.setTextAnnotationDefaultBgColor(this.stringToColor((String)obj));
            }
            if ((obj = userInfo.getFieldValue("designer_validate")) != null) {
                this.m_bValidateBeforeTransfer = (Boolean)obj;
            }
            if ((obj = userInfo.getFieldValue("designer_add_checkin")) != null) {
                this.m_bAddCheckIn = (Boolean)obj;
            }
            if (!this.m_designerCoreData.getSessionInfo().getCanSaveToDMS()) {
                this.m_bAddCheckIn = false;
            }
            if ((obj = userInfo.getFieldValue("designer_display_inherited_info")) != null) {
                this.m_bDisplayInheritedInformation = (Boolean)obj;
            }
            if ((obj = userInfo.getFieldValue("designer_use_same_step_tab")) != null) {
                this.m_bUseSameStepTab = (Boolean)obj;
            }
            if ((obj = userInfo.getFieldValue("designer_use_same_route_tab")) != null) {
                this.m_bUseSameRouteTab = (Boolean)obj;
            }
            if ((obj = userInfo.getFieldValue("designer_use_same_text_annotation_tab")) != null) {
                this.m_bUseSameTextAnnotationTab = (Boolean)obj;
            }
            if ((obj = userInfo.getFieldValue("designer_use_same_association_tab")) != null) {
                this.m_bUseSameAssociationTab = (Boolean)obj;
            }
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 740, null);
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean getShouldValidateBeforeTransfer() {
        return this.m_bValidateBeforeTransfer;
    }

    public void setShouldValidateBeforeTransfer(boolean bFlag) {
        this.m_bValidateBeforeTransfer = bFlag;
    }

    public boolean getShouldAddCheckIn() {
        return this.m_bAddCheckIn;
    }

    public void setShouldAddCheckIn(boolean bFlag) {
        this.m_bAddCheckIn = bFlag;
    }

    public boolean getShouldDisplayInheritedInformation() {
        return this.m_bDisplayInheritedInformation;
    }

    public void setShouldDisplayInheritedInformation(boolean bFlag) {
        this.m_bDisplayInheritedInformation = bFlag;
    }

    public boolean getUseSameStepPropertyTab() {
        return this.m_bUseSameStepTab;
    }

    public void setUseSameStepPropertyTab(boolean bFlag) {
        this.m_bUseSameStepTab = bFlag;
    }

    public boolean getUseSameRoutePropertyTab() {
        return this.m_bUseSameRouteTab;
    }

    public void setUseSameRoutePropertyTab(boolean bFlag) {
        this.m_bUseSameRouteTab = bFlag;
    }

    public boolean getUseSameTextAnnotationPropertyTab() {
        return this.m_bUseSameTextAnnotationTab;
    }

    public void setUseSameTextAnnotationPropertyTab(boolean bFlag) {
        this.m_bUseSameTextAnnotationTab = bFlag;
    }

    public boolean getUseSameAssociationPropertyTab() {
        return this.m_bUseSameAssociationTab;
    }

    public void setUseSameAssociationPropertyTab(boolean bFlag) {
        this.m_bUseSameAssociationTab = bFlag;
    }

    public VWMapAttribs getMapAttributes() {
        return this.m_designerCoreData.getMapAttributes();
    }

    public void savePreferencesSettings() {
        try {
            VWUserInfo userInfo = this.m_designerCoreData.getSessionInfo().getSession().fetchCurrentUserInfo();
            if (userInfo != null) {
                VWMapAttribs mapAttribs = this.m_designerCoreData.getMapAttributes();
                userInfo.setFieldValue("designer_show_collectorstepicons", new Boolean(mapAttribs.isCollectorAttrsVisible()));
                userInfo.setFieldValue("designer_show_conditionalroutes", new Boolean(mapAttribs.isConditionAttrsVisible()));
                userInfo.setFieldValue("designer_show_milestoneicons", new Boolean(mapAttribs.isMilestoneVisible()));
                userInfo.setFieldValue("designer_show_pageboundaries", new Boolean(mapAttribs.isPageBoundaryVisible()));
                userInfo.setFieldValue("designer_show_routenames", new Boolean(mapAttribs.isRouteNameVisible()));
                userInfo.setFieldValue("designer_show_stepnames", new Boolean(mapAttribs.isStepNameVisible()));
                userInfo.setFieldValue("designer_show_textannotations", new Boolean(mapAttribs.isTextAnnotationsVisible()));
                userInfo.setFieldValue("designer_text_annotation_bgcolor", this.colorToString(mapAttribs.getTextAnnotationDefaultBgColor()));
                userInfo.setFieldValue("designer_validate", new Boolean(this.m_bValidateBeforeTransfer));
                userInfo.setFieldValue("designer_add_checkin", new Boolean(this.m_bAddCheckIn));
                userInfo.setFieldValue("designer_display_inherited_info", new Boolean(this.m_bDisplayInheritedInformation));
                userInfo.setFieldValue("designer_use_same_step_tab", new Boolean(this.m_bUseSameStepTab));
                userInfo.setFieldValue("designer_use_same_route_tab", new Boolean(this.m_bUseSameRouteTab));
                userInfo.setFieldValue("designer_use_same_text_annotation_tab", new Boolean(this.m_bUseSameTextAnnotationTab));
                userInfo.setFieldValue("designer_use_same_association_tab", new Boolean(this.m_bUseSameAssociationTab));
                userInfo.save();
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 740, null);
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    private String colorToString(Color color) {
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    private Color stringToColor(String colorString) {
        Color color = null;
        try {
            if (colorString != null && colorString.length() != 0) {
                int nArrayIndex = 0;
                int[] colors = new int[3];
                do {
                    int nStringIndex;
                    if ((nStringIndex = colorString.indexOf(44)) == -1) {
                        colors[nArrayIndex] = Integer.parseInt(colorString.trim());
                        continue;
                    }
                    colors[nArrayIndex] = Integer.parseInt(colorString.substring(0, nStringIndex).trim());
                    colorString = colorString.substring(nStringIndex + 1);
                } while (++nArrayIndex < colors.length);
                if (nArrayIndex == colors.length) {
                    color = new Color(colors[0], colors[1], colors[2]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return color;
    }
}

